/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.tools.ArrayUtils;
import org.restopt.choco.ConnectivityFinderSpatialGraph;

public class LandscapeIndicesUtils {
    public static double effectiveMeshSize(UndirectedGraph g, int landscapeArea) {
        ConnectivityFinderSpatialGraph connFinder = new ConnectivityFinderSpatialGraph(g);
        connFinder.findAllCC();
        double mesh = 0.0;
        for (int i = 0; i < connFinder.getNBCC(); ++i) {
            int s = connFinder.getSizeCC()[i];
            mesh += 1.0 * (double)s * (double)s;
        }
        return mesh /= 1.0 * (double)landscapeArea;
    }

    public static double[] getSmallestEnclosingCircle(double[][] coordinates) {
        int[] points = IntStream.range(0, coordinates.length).toArray();
        return LandscapeIndicesUtils.minidisk(points, coordinates);
    }

    public static final double[] minidisk(int[] pointsArray, double[][] coordinates) {
        int nbPoints = pointsArray.length;
        if (nbPoints == 0) {
            return new double[0];
        }
        if (nbPoints == 1) {
            double[] center = coordinates[pointsArray[0]];
            return new double[]{center[0], center[1], 0.0};
        }
        if (nbPoints == 2) {
            int i = pointsArray[0];
            int j = pointsArray[1];
            double[] p1 = coordinates[i];
            double[] p2 = coordinates[j];
            double[] center = LandscapeIndicesUtils.midpoint(p1, p2);
            return new double[]{center[0], center[1], LandscapeIndicesUtils.distance(p1, p2) / 2.0};
        }
        int[] pointsCopy = Arrays.copyOf(pointsArray, pointsArray.length);
        ArrayUtils.randomPermutations(pointsCopy, System.currentTimeMillis());
        double[] p1 = coordinates[pointsCopy[0]];
        double[] p2 = coordinates[pointsCopy[1]];
        double[] center = LandscapeIndicesUtils.midpoint(p1, p2);
        double r = LandscapeIndicesUtils.distance(p1, p2) / 2.0;
        for (int i = 2; i < pointsCopy.length; ++i) {
            double[] pi = coordinates[pointsCopy[i]];
            if (!(LandscapeIndicesUtils.distance(center, pi) > r)) continue;
            double[] circle = LandscapeIndicesUtils.b_minidisk_one(coordinates, pointsCopy, i);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    private static final double[] b_minidisk_one(double[][] coordinates, int[] shuffled, int i) {
        double[] p1 = coordinates[shuffled[0]];
        double[] pi = coordinates[shuffled[i]];
        double[] center = LandscapeIndicesUtils.midpoint(p1, pi);
        double r = LandscapeIndicesUtils.distance(p1, pi) / 2.0;
        for (int j = 1; j < i; ++j) {
            double[] pj = coordinates[shuffled[j]];
            if (!(LandscapeIndicesUtils.distance(center, pj) > r)) continue;
            double[] circle = LandscapeIndicesUtils.b_minidisk_two(coordinates, shuffled, i, j);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    private static final double[] b_minidisk_two(double[][] coordinates, int[] shuffled, int i, int j) {
        double[] pi = coordinates[shuffled[i]];
        double[] pj = coordinates[shuffled[j]];
        double[] center = LandscapeIndicesUtils.midpoint(pi, pj);
        double r = LandscapeIndicesUtils.distance(pi, pj) / 2.0;
        for (int k = 0; k < j; ++k) {
            double[] pk = coordinates[shuffled[k]];
            if (!(LandscapeIndicesUtils.distance(center, pk) > r)) continue;
            double[] circle = LandscapeIndicesUtils.circumcircle(pi, pj, pk);
            center[0] = circle[0];
            center[1] = circle[1];
            r = circle[2];
        }
        return new double[]{center[0], center[1], r};
    }

    public static final double[] vector(double[] p1, double[] p2) {
        return new double[]{p1[0] + p2[0], p1[1] + p2[1]};
    }

    public static final double[] midpoint(double[] p1, double[] p2) {
        double[] v = LandscapeIndicesUtils.vector(p1, p2);
        return new double[]{v[0] / 2.0, v[1] / 2.0};
    }

    public static final double distance(double[] p1, double[] p2) {
        return Math.sqrt(Math.pow(p1[0] - p2[0], 2.0) + Math.pow(p1[1] - p2[1], 2.0));
    }

    public static final double[] circumcircle(double[] a2, double[] b, double[] c) {
        double d = 2.0 * (a2[0] * (b[1] - c[1]) + b[0] * (c[1] - a2[1]) + c[0] * (a2[1] - b[1]));
        double cx = ((Math.pow(a2[0], 2.0) + Math.pow(a2[1], 2.0)) * (b[1] - c[1]) + (Math.pow(b[0], 2.0) + Math.pow(b[1], 2.0)) * (c[1] - a2[1]) + (Math.pow(c[0], 2.0) + Math.pow(c[1], 2.0)) * (a2[1] - b[1])) / d;
        double cy = ((Math.pow(a2[0], 2.0) + Math.pow(a2[1], 2.0)) * (c[0] - b[0]) + (Math.pow(b[0], 2.0) + Math.pow(b[1], 2.0)) * (a2[0] - c[0]) + (Math.pow(c[0], 2.0) + Math.pow(c[1], 2.0)) * (b[0] - a2[0])) / d;
        double cr = LandscapeIndicesUtils.distance(new double[]{cx, cy}, a2);
        return new double[]{cx, cy, cr};
    }
}

