/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.delta.SetDelta;
import org.chocosolver.solver.variables.delta.monitor.SetDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.SetView;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.procedure.IntProcedure;

public class SetIntsView<I extends IntVar>
extends SetView<I> {
    private final int[] v;
    private final int offset;
    private final IIntDeltaMonitor[] idm;
    private final IntProcedure[] valRemoved;
    private final ISet lb;
    private final ISet ub;
    protected boolean reactOnModification;
    private ISetDelta delta;

    @SafeVarargs
    protected SetIntsView(String name, int[] v, int offset, I ... variables) {
        super(name, variables);
        int i;
        assert (v.length == variables.length);
        this.v = v;
        this.offset = offset;
        this.idm = new IIntDeltaMonitor[this.getNbObservedVariables()];
        this.valRemoved = new IntProcedure[this.getNbObservedVariables()];
        this.lb = SetFactory.makeStoredSet(SetType.BITSET, 0, variables[0].getModel());
        this.ub = SetFactory.makeStoredSet(SetType.BITSET, 0, variables[0].getModel());
        for (i = 0; i < this.getNbObservedVariables(); ++i) {
            this.idm[i] = ((IntVar[])this.getVariables())[i].monitorDelta(this);
            this.idm[i].startMonitoring();
            int finalI = i;
            this.valRemoved[i] = val -> {
                if (val == this.v[finalI]) {
                    this.ub.remove(finalI + offset);
                    if (this.reactOnModification) {
                        this.delta.add(finalI + offset, 1, this);
                    }
                    this.notifyPropagators(SetEventType.REMOVE_FROM_ENVELOPE, this);
                }
            };
        }
        for (i = 0; i < variables.length; ++i) {
            if (variables[i].isInstantiatedTo(v[i])) {
                this.lb.add(i + offset);
            }
            if (!variables[i].contains(v[i])) continue;
            this.ub.add(i + offset);
        }
    }

    @SafeVarargs
    public SetIntsView(int[] v, int offset, I ... variables) {
        this("INTS_SET_VIEW[" + String.join((CharSequence)",", (CharSequence[])Arrays.stream(variables).map(Variable::getName).toArray(String[]::new)) + "]", v, offset, (IntVar[])variables);
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        if (((IntVar[])this.getVariables())[element - this.offset].removeValue(this.v[element - this.offset], this)) {
            this.ub.remove(element);
            if (this.reactOnModification) {
                this.delta.add(element, 1, this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        if (((IntVar[])this.getVariables())[element - this.offset].instantiateTo(this.v[element - this.offset], this)) {
            this.lb.add(element);
            if (this.reactOnModification) {
                this.delta.add(element, 0, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (((IntVar[])this.getVariables())[variableIdx].isInstantiatedTo(this.v[variableIdx])) {
            this.lb.add(variableIdx + this.offset);
            if (this.reactOnModification) {
                this.delta.add(variableIdx + this.offset, 0, this);
            }
            this.notifyPropagators(SetEventType.ADD_TO_KER, this);
        } else {
            this.idm[variableIdx].forEachRemVal(this.valRemoved[variableIdx]);
        }
    }

    @Override
    public ISet getLB() {
        return this.lb;
    }

    @Override
    public ISet getUB() {
        return this.ub;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        ISet s = SetFactory.makeConstantSet(Arrays.stream(value).map(i -> i - this.offset).toArray());
        for (int i2 = 0; i2 < this.getNbObservedVariables(); ++i2) {
            IntVar var = ((IntVar[])this.getVariables())[i2];
            if (s.contains(i2)) {
                this.lb.add(i2 + this.offset);
                var.instantiateTo(this.v[i2], this);
                continue;
            }
            this.ub.remove(i2 + this.offset);
            var.removeValue(this.v[i2], this);
        }
        return changed;
    }

    @Override
    public boolean isInstantiated() {
        for (int i = 0; i < this.getNbObservedVariables(); ++i) {
            if (((IntVar[])this.getVariables())[i].isInstantiated() || !((IntVar[])this.getVariables())[i].contains(this.v[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ISetDelta getDelta() {
        return this.delta;
    }

    @Override
    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new SetDelta(this.model.getEnvironment());
        }
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new SetDeltaMonitor(this.getDelta(), propagator);
    }
}

