/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.MathUtils;

public class PropPowEven
extends Propagator<IntVar> {
    protected static final double PRECISION = 1.0E-9;
    final IntIterableBitSet vrms;
    final boolean bothEnum;
    final int exponent;

    public PropPowEven(IntVar X, IntVar Y, int n) {
        super((Variable[])ArrayUtils.toArray(X, Y), (Priority)PropagatorPriority.BINARY, false);
        this.bothEnum = X.hasEnumeratedDomain() && Y.hasEnumeratedDomain();
        this.vrms = new IntIterableBitSet();
        this.exponent = n;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return this.bothEnum ? IntEventType.all() : IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            this.setBounds();
        } while (this.updateHolesinX() | this.updateHolesinY());
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(((IntVar[])this.vars)[0].getValue() == this.pow(((IntVar[])this.vars)[1].getValue()));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = %s^%d", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString(), this.exponent);
    }

    void setBounds() throws ContradictionException {
        this.updateLowerBoundofX();
        this.updateUpperBoundofX();
        if (this.updateLowerBoundofY() | this.updateUpperBoundofY()) {
            this.setBounds();
        }
    }

    int floor_nroot(int n) {
        if (n < 0) {
            return 0;
        }
        return MathUtils.safeCast((long)Math.floor(Math.pow(n, 1.0 / ((double)this.exponent - 1.0E-9))));
    }

    int ceil_nroot(int n) {
        if (n < 0) {
            return 0;
        }
        return MathUtils.safeCast((long)Math.ceil(Math.pow(n, 1.0 / ((double)this.exponent + 1.0E-9))));
    }

    int pow(int n) {
        return MathUtils.safeCast((long)Math.pow(n, this.exponent));
    }

    boolean perfectNth(int n) {
        return Math.pow(this.floor_nroot(n), this.exponent) == (double)n;
    }

    protected void updateLowerBoundofX() throws ContradictionException {
        int a0 = ((IntVar[])this.vars)[1].nextValue(-1);
        int b0 = Math.max(-2147483647, ((IntVar[])this.vars)[1].previousValue(1));
        ((IntVar[])this.vars)[0].updateLowerBound(Math.min(this.pow(a0), this.pow(b0)), (ICause)this);
        if (!this.perfectNth(((IntVar[])this.vars)[0].getLB())) {
            ((IntVar[])this.vars)[0].updateLowerBound(this.pow(this.ceil_nroot(((IntVar[])this.vars)[0].getLB())), (ICause)this);
        }
    }

    protected void updateUpperBoundofX() throws ContradictionException {
        ((IntVar[])this.vars)[0].updateUpperBound(Math.max(this.pow(((IntVar[])this.vars)[1].getLB()), this.pow(((IntVar[])this.vars)[1].getUB())), (ICause)this);
    }

    protected boolean updateHolesinX() throws ContradictionException {
        int value;
        int ub;
        if (!((IntVar[])this.vars)[0].hasEnumeratedDomain()) {
            return false;
        }
        boolean impact = false;
        if (this.model.getSolver().getNodeCount() == 0L) {
            ub = ((IntVar[])this.vars)[0].getUB();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
            value = ((IntVar[])this.vars)[0].getLB();
            while (value <= ub) {
                if (!this.perfectNth(value)) {
                    this.vrms.add(value);
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            impact = ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        }
        if (this.bothEnum) {
            ub = ((IntVar[])this.vars)[0].getUB();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
            value = ((IntVar[])this.vars)[0].getLB();
            while (value <= ub) {
                int nroot = this.floor_nroot(value);
                if (!((IntVar[])this.vars)[1].contains(nroot) && !((IntVar[])this.vars)[1].contains(-nroot)) {
                    this.vrms.add(value);
                }
                value = ((IntVar[])this.vars)[0].nextValue(value);
            }
            impact |= ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        }
        return impact;
    }

    protected boolean updateLowerBoundofY() throws ContradictionException {
        if (((IntVar[])this.vars)[1].getLB() >= 0) {
            return ((IntVar[])this.vars)[1].updateLowerBound(this.ceil_nroot(((IntVar[])this.vars)[0].getLB()), (ICause)this);
        }
        return ((IntVar[])this.vars)[1].updateLowerBound(-this.floor_nroot(((IntVar[])this.vars)[0].getUB()), (ICause)this);
    }

    protected boolean updateUpperBoundofY() throws ContradictionException {
        if (((IntVar[])this.vars)[1].getUB() < 0) {
            return ((IntVar[])this.vars)[1].updateUpperBound(-this.ceil_nroot(((IntVar[])this.vars)[0].getLB()), (ICause)this);
        }
        return ((IntVar[])this.vars)[1].updateUpperBound(this.floor_nroot(((IntVar[])this.vars)[0].getUB()), (ICause)this);
    }

    protected final boolean updateHolesinY() throws ContradictionException {
        if (!((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            return false;
        }
        boolean impact = false;
        int val = this.ceil_nroot(((IntVar[])this.vars)[0].getLB()) - 1;
        if (val >= 0) {
            impact = ((IntVar[])this.vars)[1].removeInterval(-val, val, this);
        }
        if (this.bothEnum) {
            int ub = ((IntVar[])this.vars)[1].getUB();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[1].getLB());
            int value = ((IntVar[])this.vars)[1].getLB();
            while (value <= ub) {
                if (!((IntVar[])this.vars)[0].contains(this.pow(value))) {
                    this.vrms.add(value);
                }
                value = ((IntVar[])this.vars)[1].nextValue(value);
            }
            impact |= ((IntVar[])this.vars)[1].removeValues(this.vrms, this);
        }
        return impact;
    }
}

