% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ethnicity.R
\name{predict_fullname}
\alias{predict_fullname}
\title{Predict ethnicity from full name}
\usage{
predict_fullname(
  firstnames,
  lastnames,
  na.rm = FALSE,
  threads = 0L,
  labels = NULL,
  model_path = NULL
)
}
\arguments{
\item{firstnames}{character vector, first names}

\item{lastnames}{character vector, last names}

\item{na.rm}{bool, default to FALSE, whether to remove the na in the `lastnames`}

\item{threads}{int, number of threads for multi-threading}

\item{labels}{character vector, labels of the classification model, needs to be in the same order as the trained model}

\item{model_path}{character file path, the path to the trained model in .json format (converted from Keras by frugally-deep)}
}
\value{
data.frame with predicted probability and predicted ethnicity
}
\description{
Predicts ethnicity from first names and last names, using self-trained model with customized labels.
This is designed for advanced users who wish to use their own models. 
For most use cases, use [predict_ethnicity()] for prediction.
}
