% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\alias{import_main}
\alias{import_builtins}
\alias{import_from_path}
\title{Import a Python module}
\usage{
import(module, as = NULL, convert = TRUE, delay_load = FALSE)

import_main(convert = TRUE, delay_load = FALSE)

import_builtins(convert = TRUE, delay_load = FALSE)

import_from_path(module, path = ".", convert = TRUE, delay_load = FALSE)
}
\arguments{
\item{module}{The name of the Python module.}

\item{as}{An alias for module name (affects names of R classes). Note that
this is an advanced parameter that should generally only be used in package
development (since it affects the S3 name of the imported class and can
therefore interfere with S3 method dispatching).}

\item{convert}{Boolean; should Python objects be automatically converted
to their \R equivalent? If set to \code{FALSE}, you can still manually convert
Python objects to \R via the \code{\link[=py_to_r]{py_to_r()}} function.}

\item{delay_load}{Boolean; delay loading the module until it is first used?
When \code{FALSE}, the module will be loaded immediately. See \strong{Delay Load}
for advanced usages.}

\item{path}{The path from which the module should be imported.}
}
\value{
An \R object wrapping a Python module. Module attributes can be accessed
via the \code{$} operator, or via \code{\link[=py_get_attr]{py_get_attr()}}.
}
\description{
Import the specified Python module, making it available for use from \R.
}
\section{Python Built-ins}{


Python's built-in functions (e.g. \code{len()}) can be accessed via Python's
built-in module. Because the name of this module has changed between Python 2
and Python 3, we provide the function \code{import_builtins()} to abstract over
that name change.
}

\section{Delay Load}{


The \code{delay_load} parameter accepts a variety of inputs. If you just need to
ensure your module is lazy-loaded (e.g. because you are a package author and
want to avoid initializing Python before the user has explicitly requested it),
then passing \code{TRUE} is normally the right choice.

You can also provide a list of named functions, which act as callbacks to be
run when the module is later loaded. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{delay_load = list(

  # run before the module is loaded
  before_load = function() \{ ... \}

  # run immediately after the module is loaded
  on_load = function() \{ ... \}

  # run if an error occurs during module import
  on_error = function(error) \{ ... \}

)
}\if{html}{\out{</div>}}

Alternatively, if you supply only a single function, that will be treated as
an \code{on_load} handler.
}

\section{Import from Path}{


\code{import_from_path()} can be used in you need to import a module from an arbitrary
filesystem path. This is most commonly used when importing modules bundled with an
\R package -- for example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{path <- system.file("python", package = <package>)
reticulate::import_from_path(<module>, path = path, delay_load = TRUE)
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
main <- import_main()
sys <- import("sys")
}

}
