% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retractcheck.R
\name{retractcheck_html}
\alias{retractcheck_html}
\title{Check html file for retractions}
\usage{
retractcheck_html(path, ...)
}
\arguments{
\item{path}{Path to html file to check}

\item{...}{Arguments passed on to \code{retractcheck}
\describe{
  \item{database}{Character. Abbreviation of the databases to search
(\code{or} for openretractions.com).  # #' and \code{rw} for #
#' retractiondatabase.com). Note that in the absence of an API,
# #' searching retractiondatabase.com is rather slow.}
  \item{return}{Character. If \code{all}, all DOIs are queried and
all results are returned; if \code{unique}, the DOIs are
queried in the order specified until either a correction or
retraction notice is found or all databases have been queried.}
}}
}
\value{
\code{\link{retractcheck}} dataframe without filenames
}
\description{
Check a html file for retractions.
}
\examples{
\donttest{
  retractcheck_html(system.file("extdata", "manuscript.html", package = "retractcheck"))
}
}
