% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{get_csv_files}
\alias{get_csv_files}
\title{List FACTS-generated CSV files}
\usage{
get_csv_files(csv_files, numbered = TRUE)
}
\arguments{
\item{csv_files}{Character vector of directories containing
numbered CSV files}

\item{numbered}{Logical. If \code{TRUE},
only list the numbered files like \code{patients00001.csv},
\code{weeks00017.csv}, etc. If \code{FALSE}, only list the non-numbered files
like \code{simulations.csv} and \code{simulations_freq_locf.csv}.
Avoid \code{summary.csv} files. They are not reliable on Linux.}
}
\value{
A character vector of names of CSV files.
}
\description{
List output CSV files in a directory or directories.
}
\examples{
facts_file <- get_facts_file_example("contin.facts")
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
out <- run_facts(
  facts_file,
  n_sims = 2L,
  verbose = FALSE
)
get_csv_files(out)
}
}
