% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{rfb_download}
\alias{rfb_download}
\title{Download RFB files}
\usage{
rfb_download(ufs = NULL, path, verbose = TRUE)
}
\arguments{
\item{ufs}{character vector of UFs to download. If \code{NULL} (default), downloads all UFs.}

\item{path}{path to download the files.}

\item{verbose}{print status messages}
}
\value{
character vector containing full paths of downloaded files.

This function needs internet connection. It does not overwrite existing files.
}
\description{
Downloads RFB fixed width files from selected UFs.
}
\examples{

\donttest{
rfb_download("AC", path = file.path(tempdir(), "txt_files"))
rfb_download(c("AC", "RR"), path = file.path(tempdir(), "txt_files"))
}
}
