% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{popgrowth}
\alias{popgrowth}
\title{popgrowth}
\usage{
popgrowth(species_list, fields = NULL, limit = 200,
  server = getOption("FISHBASE_API", FISHBASE_API), ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species").}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to the amount
of data transfered over the network if only certain columns are needed.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{...}{additional arguments to httr::GET}
}
\value{
a table of population growth information by species; see details
}
\description{
This table contains information on growth, natural mortality and length
at first maturity, which serve as inputs to many fish stock assessment
models. The data can also be used to generate empirical relationships
between growth parameters or natural mortality estimates, and their
correlates (e.g., body shape, temperature, etc.), a line of research
that is useful both for stock assessment and for increasing understanding
of the evolution of life-history strategies
}
\examples{
\dontrun{
popgrowth("Oreochromis niloticus")
}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_popgrowth_table.htm
}

