% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species.R
\name{species}
\alias{species}
\alias{species_info}
\title{species}
\usage{
species(species_list = NULL, fields = NULL, query = NULL, limit = 200,
  server = getOption("FISHBASE_API", FISHBASE_API), ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, the table will be loaded up to the limit. This makes it possible to load an entire table without knowledge of the species in the table, thus avoiding uneccesary API calls.}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to limit the amount
of data transfered over the network if only certain columns are needed.}

\item{query}{a named list specifying specific subsets of fields.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{...}{additional arguments to httr::GET}
}
\value{
a data.frame with rows for species and columns for the fields returned by the query (FishBase 'species' table)
}
\description{
Provide wrapper to work with species lists.
}
\details{
The Species table is the heart of FishBase. This function provides a convenient way to 
query, tidy, and assemble data from that table given an entire list of species.
For details, see: http://www.fishbase.org/manual/english/fishbasethe_species_table.htm

Species scientific names are defined according to fishbase taxonomy and nomenclature.
}
\examples{
\dontrun{

species(c("Labroides bicolor", "Bolbometopon muricatum")) 
species(c("Labroides bicolor", "Bolbometopon muricatum"), fields = species_fields$habitat) 

}
}

