% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_rm_plot}
\alias{rfm_rm_plot}
\alias{rfm_fm_plot}
\alias{rfm_rf_plot}
\title{RFM Scatter plot}
\usage{
rfm_rm_plot(
  rfm_table,
  point_color = "blue",
  xaxis_title = "Monetary",
  yaxis_title = "Recency",
  plot_title = "Recency vs Monetary",
  print_plot = TRUE
)

rfm_fm_plot(
  rfm_table,
  point_color = "blue",
  xaxis_title = "Monetary",
  yaxis_title = "Frequency",
  plot_title = "Frequency vs Monetary",
  print_plot = TRUE
)

rfm_rf_plot(
  rfm_table,
  point_color = "blue",
  xaxis_title = "Frequency",
  yaxis_title = "Recency",
  plot_title = "Recency vs Frequency",
  print_plot = TRUE
)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{point_color}{Color of the scatter points.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{plot_title}{Title of the plot.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
Scatter plot.
}
\description{
Examine the relationship between recency, frequency
  and monetary values.
}
\examples{
# rfm table
analysis_date <- lubridate::as_date('2006-12-31')
rfm_result <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# monetary value vs recency
rfm_rm_plot(rfm_result)

# frequency vs monetary value
rfm_fm_plot(rfm_result)

# frequency vs recency
rfm_rf_plot(rfm_result)

}
