% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\docType{methods}
\name{cor,ml.data.frame,ANY-method}
\alias{cor,ml.data.frame,ANY-method}
\title{Correlation Matrix}
\usage{
\S4method{cor}{ml.data.frame,ANY}(x, y = NULL, use = NULL, method = NULL)
}
\arguments{
\item{x}{a \link{ml.data.frame}}

\item{y}{not used when doing a matrix}

\item{use}{not implemented}

\item{method}{not implemented}
}
\value{
The correlation coefficient matrix
}
\description{
Returns the Pearson correlation coefficient matrix of all numeric fields in a \link{ml.data.frame}
}
\details{
The function eliminates all fields pairs for which either the first element or the second
element is empty. After the elimination, if the length of the input is less than 2,
the function returns the empty sequence. After the elimination, if the standard
deviation of the first column or the standard deviation of the second column is 0,
the function returns the empty sequence.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn, collection = "iris")
 # return the correlation matrix
 cor(mlIris)
}
}

