% Generated by roxygen2 (4.0.0): do not edit by hand
\name{gs_gauge_detail}
\alias{gs_gauge_detail}
\title{Gets details for a gauge.}
\usage{
gs_gauge_detail(id, key = NULL, keyname = "GaugesKey", callopts = list())
}
\arguments{
  \item{id}{id of the gauge}

  \item{key}{API key. If left NULL, function looks for key
  in your options settings defined in the keyname
  parameter}

  \item{keyname}{Your API key name in your .Rprofile file}

  \item{callopts}{Curl debugging options passed in to
  httr::GET}
}
\description{
Gets details for a gauge.
}
\details{
Gets details on a gauge, by specifying the id of the gauge.
}
\note{
Note that these examples only work if you provide your
		Gaug.es API key either by passing in the function, or
		storing your key in your .Rprofile file, defaults to looking
		for an entry of "GaugesKey".
}
\examples{
\dontrun{
# create a dummy gauge
out <- gs_gauge_create()

# and get detail on it
gs_gauge_detail(out$id)
}
}

