% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_fetch.R
\name{map_fetch}
\alias{map_fetch}
\title{Fetch aggregated density maps of GBIF occurrences}
\usage{
map_fetch(source = "density", x = 0, y = 0, z = 0,
  format = "@1x.png", srs = "EPSG:4326", bin = NULL,
  hexPerTile = NULL, squareSize = NULL, style = "classic.point",
  taxonKey = NULL, datasetKey = NULL, country = NULL,
  publishingOrg = NULL, publishingCountry = NULL, year = NULL,
  basisOfRecord = NULL, ...)
}
\arguments{
\item{source}{(character) Either \code{density} for fast, precalculated tiles,
or \code{adhoc} for any search. Default: \code{density}}

\item{x}{(integer) the column. Default: 0}

\item{y}{(integer) the row. Default: 0}

\item{z}{(integer) the zoom. Default: 0}

\item{format}{(character) The data format, one of:
\itemize{
\item \code{@Hx.png} for a 256px raster tile
\item \code{@1x.png} for a 512px raster tile (the default)
\item \code{@2x.png} for a 1024px raster tile
\item \code{@3x.png} for a 2048px raster tile
\item \code{@4x.png} for a 4096px raster tile
}}

\item{srs}{(character) Spatial reference system. One of:
\itemize{
\item \code{EPSG:3857} (Web Mercator)
\item \code{EPSG:4326} (WGS84 plate care?)
\item \code{EPSG:3575} (Arctic LAEA on 10 degrees E)
\item \code{EPSG:3031} (Antarctic stereographic)
}}

\item{bin}{(character) \code{square} or \code{hex} to aggregate occurrence counts into
squares or hexagons. Points by default. optional}

\item{hexPerTile}{(integer) sets the size of the hexagons
(the number horizontally across a tile). optional}

\item{squareSize}{(integer) sets the size of the squares. Choose a factor
of 4096 so they tessalate correctly: probably from 8, 16, 32, 64, 128,
256, 512. optional}

\item{style}{(character) for raster tiles, choose from the available styles.
Defaults to classic.point. optional. THESE DON'T WORK YET.}

\item{taxonKey}{(integer/numeric/character) search by taxon key, can only
supply 1. optional}

\item{datasetKey}{(character) search by taxon key, can only supply 1.
optional}

\item{country}{(character) search by taxon key, can only supply 1.
optional}

\item{publishingOrg}{(character) search by taxon key, can only supply 1.
optional}

\item{publishingCountry}{(character) search by taxon key, can only
supply 1. optional}

\item{year}{(integer) integer that limits the search to a certain year or,
if passing a vector of integers, multiple years, for example
\code{1984} or \code{c(2016, 2017, 2018)} or \code{2010:2015} (years 2010 to 2015). optional}

\item{basisOfRecord}{(character) one or more basis of record states to
include records with that basis of record. The full list is: \code{c("OBSERVATION", "HUMAN_OBSERVATION", "MACHINE_OBSERVATION", "MATERIAL_SAMPLE", "PRESERVED_SPECIMEN", "FOSSIL_SPECIMEN", "LIVING_SPECIMEN", "LITERATURE", "UNKNOWN")}. optional}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
an object of class \code{RasterLayer}
}
\description{
This function is a wrapper for the GBIF mapping api version 2.0.
The mapping API is a web map tile service making it straightforward to
visualize GBIF content on interactive maps, and overlay content from other
sources. It returns tile maps with number of
GBIF records per area unit that can be used in a variety of ways, for example
in interactive leaflet web maps. Map details are specified by a number of
query parameters, some of them optional. Full documentation of the GBIF
mapping api can be found at https://www.gbif.org/developer/maps
}
\details{
This function uses the arguments passed on to generate a query
to the GBIF web map API. The API returns a web tile object as png that is
read and converted into an R raster object. The break values or nbreaks
generate a custom colour palette for the web tile, with each bin
corresponding to one grey value. After retrieval, the raster is reclassified
to the actual break values. This is a somewhat hacky but nonetheless
functional solution in the absence of a GBIF raster API implementation.

We add extent and set the projection for the output. You can reproject
after retrieving the output.
}
\note{
Styles don't work yet, sorry, we'll try to fix it asap.
}
\examples{
\dontrun{
if (
 requireNamespace("png", quietly = TRUE) &&
 requireNamespace("raster", quietly = TRUE)
) {
  x <- map_fetch(taxonKey = 2480498, year = 2007:2011)
  x
  # gives a RasterLayer object
  class(x)
  # visualize
  library(raster)
  plot(x)

  # different srs
  ## 3857
  y <- map_fetch(taxonKey = 2480498, year = 2010, srs = "EPSG:3857")
  plot(y)
  ## 3031
  z <- map_fetch(taxonKey = 2480498, year = 2010, srs = "EPSG:3031", verbose = TRUE)
  plot(z)
  # 3575
  z <- map_fetch(taxonKey = 2480498, year = 2010, srs = "EPSG:3575")
  plot(z)

  # bin
  plot(map_fetch(taxonKey = 212, year = 1998, bin = "hex",
     hexPerTile = 30, style = "classic-noborder.poly"))

  # styles
  plot(map_fetch(taxonKey = 2480498, style = "purpleYellow.point"))

  # query with basisOfRecord
  map_fetch(taxonKey = 2480498, year = 2010,
    basisOfRecord = "HUMAN_OBSERVATION")
  map_fetch(taxonKey = 2480498, year = 2010,
    basisOfRecord = c("HUMAN_OBSERVATION", "LIVING_SPECIMEN"))
 }
}
}
\references{
https://www.gbif.org/developer/maps
}
\seealso{
\code{\link[=mvt_fetch]{mvt_fetch()}}
}
\author{
Laurens Geffert \email{laurensgeffert@gmail.com}
}
