% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_issues.R
\name{name_issues}
\alias{name_issues}
\title{Parse and examine further GBIF name issues on a dataset.}
\usage{
name_issues(.data, ..., mutate = NULL)
}
\arguments{
\item{.data}{Output from a call to \code{\link[=name_usage]{name_usage()}}, but only if
\code{return="all"}, or \code{return="data"}, otherwise function stops with error.}

\item{...}{Named parameters to only get back (e.g. bbmn), or to
remove (e.g. -bbmn).}

\item{mutate}{(character) One of:
\itemize{
\item \code{split} Split issues into new columns.
\item \code{expand} Expand issue abbreviated codes into descriptive names.
for downloads datasets, this is not super useful since the
issues come to you as expanded already.
\item \code{split_expand} Split into new columns, and expand issue names.
}

For split and split_expand, values in cells become y ("yes") or n ("no")}
}
\description{
Parse and examine further GBIF name issues on a dataset.
}
\examples{
\dontrun{
# what do issues mean, can print whole table
head(gbif_issues())
# or just name related issues
gbif_issues()[which(gbif_issues()$type \%in\% c("name")),]
# or search for matches
gbif_issues()[gbif_issues()$code \%in\% c('bbmn','clasna','scina'),]
# compare out data to after name_issues use
(aa <- name_usage(name = "Lupus"))
aa \%>\% name_issues("clasna")

## or parse issues in various ways
### remove data rows with certain issue classes
aa \%>\% name_issues(-clasna, -scina)

### expand issues to more descriptive names
aa \%>\% name_issues(mutate = "expand")

### split and expand
aa \%>\% name_issues(mutate = "split_expand")

### split, expand, and remove an issue class
aa \%>\% name_issues(-bbmn, mutate = "split_expand")

## Or you can use name_issues without \%>\%
name_issues(aa, -bbmn, mutate = "split_expand")
}
}
\references{
\url{https://gbif.github.io/gbif-api/apidocs/org/gbif/api/vocabulary/NameUsageIssue.html}
}
