% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_wkt.r
\name{check_wkt}
\alias{check_wkt}
\title{Check input WKT}
\usage{
check_wkt(wkt = NULL, skip_validate = FALSE)
}
\arguments{
\item{wkt}{(character) one or more Well Known Text objects}

\item{skip_validate}{(logical) whether to skip \code{wellknown::validate_wkt}
call or not. Default: \code{FALSE}}
}
\description{
Check input WKT
}
\examples{
\dontrun{
check_wkt('POLYGON((30.1 10.1, 10 20, 20 60, 60 60, 30.1 10.1))')
check_wkt('POINT(30.1 10.1)')
check_wkt('LINESTRING(3 4,10 50,20 25)')

# check many passed in at once
check_wkt(c('POLYGON((30.1 10.1, 10 20, 20 60, 60 60, 30.1 10.1))',
  'POINT(30.1 10.1)'))

# bad WKT
# wkt <- 'POLYGON((30.1 10.1, 10 20, 20 60, 60 60, 30.1 a))'
# check_wkt(wkt)

# many wkt's, semi-colon separated, for many repeated "geometry" args
wkt <- "POLYGON((-102.2 46.0,-93.9 46.0,-93.9 43.7,-102.2 43.7,-102.2 46.0))
;POLYGON((30.1 10.1, 10 20, 20 40, 40 40, 30.1 10.1))"
check_wkt(gsub("\n", '', wkt))
}
}
