% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_backbone_checklist.R
\name{name_backbone_checklist}
\alias{name_backbone_checklist}
\title{Lookup names in the GBIF backbone taxonomy in a checklist.}
\usage{
name_backbone_checklist(name_data = NULL, verbose = FALSE, curlopts = list())
}
\arguments{
\item{name_data}{(data.frame or vector) see details.}

\item{verbose}{(logical) If true it shows alternative matches which were
considered but then rejected}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A \code{data.frame} of matched names.
}
\description{
Lookup names in the GBIF backbone taxonomy in a checklist.
}
\details{
This function is a wrapper for  \code{name_backbone()}, which will work with
a list of names (a vector or a data.frame). The data.frame should have the
following column names, but \strong{only the 'name' column is required}. If only
one column is present, then that column is assumed to be the 'name' column.
\itemize{
\item \strong{name} : (required)
\item \strong{rank} : (optional)
\item \strong{kingdom} : (optional)
\item \strong{phylum} : (optional)
\item \strong{class} : (optional)
\item \strong{order} : (optional)
\item \strong{family} : (optional)
\item \strong{genus} : (optional)
}

The input columns will be returned as "verbatim_name","verbatim_rank",
"verbatim_phylum" ect. A column of "verbatim_index" will also be returned
giving the index of the input.

The following aliases for the 'name' column will work (any case or with '_'
will work) :
\itemize{
\item "scientificName", "ScientificName", "scientific_name" ...
\item "sci_name", "sciname", "SCI_NAME" ...
\item "names", "NAMES" ...
\item "species", "SPECIES" ...
\item "species_name", "speciesname" ...
\item "sp_name", "SP_NAME", "spname" ...
\item "taxon_name", "taxonname", "TAXON NAME" ...
}

If more than one aliases is present and no column is named 'name', then the
left-most column with an acceptable aliased name above is used.

This function can also be used with a character vector of names. In that case
no column names are needed of course.

This function is very similar to the GBIF species-lookup tool.
\href{https://www.gbif.org/tools/species-lookup}{https://www.gbif.org/tools/species-lookup}.

If you have 1000s of names to match, it can take some minutes to get back all
of the matches. I have tested it with 60K names. Scientific names with author details
usually get better matches.

See also article \href{https://docs.ropensci.org/rgbif/articles/taxonomic_names.html}{Working With Taxonomic Names}.
}
\examples{
\dontrun{

library(rgbif)

name_data <- data.frame(
 scientificName = c(
   "Cirsium arvense (L.) Scop.", # a plant
   "Calopteryx splendens (Harris, 1780)", # an insect
   "Puma concolor (Linnaeus, 1771)", # a big cat
   "Ceylonosticta alwisi (Priyadarshana & Wijewardhane, 2016)", # newly discovered insect 
   "Puma concuolor (Linnaeus, 1771)", # a mis-spelled big cat
   "Fake species (John Waller 2021)", # a fake species
   "Calopteryx" # Just a Genus   
 ), description = c(
   "a plant",
   "an insect",
   "a big cat",
   "newly discovered insect",
   "a mis-spelled big cat",
   "a fake species",
   "just a GENUS"
 ), 
 kingdom = c(
   "Plantae",
   "Animalia",
   "Animalia",
   "Animalia",
   "Animalia",
   "Johnlia",
   "Animalia"
 ))

name_backbone_checklist(name_data)
name_backbone_checklist(name_data,verbose=TRUE) # return non-accepted names too 

# works with just vectors too 
name_list <- c(
"Cirsium arvense (L.) Scop.", 
"Calopteryx splendens (Harris, 1780)", 
"Puma concolor (Linnaeus, 1771)", 
"Ceylonosticta alwisi (Priyadarshana & Wijewardhane, 2016)", 
"Puma concuolor", 
"Fake species (John Waller 2021)", 
"Calopteryx")

name_backbone_checklist(name_list)
name_backbone_checklist(name_list,verbose=TRUE)

}

}
