% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_search.r
\name{dataset_search}
\alias{dataset_search}
\title{Search datasets in GBIF.}
\usage{
dataset_search(
  query = NULL,
  country = NULL,
  type = NULL,
  keyword = NULL,
  publishingOrg = NULL,
  hostingOrg = NULL,
  publishingCountry = NULL,
  decade = NULL,
  facet = NULL,
  facetMincount = NULL,
  facetMultiselect = NULL,
  limit = 100,
  start = NULL,
  pretty = FALSE,
  return = NULL,
  curlopts = list()
)
}
\arguments{
\item{query}{Query term(s) for full text search.  The value for this
parameter can be a simple word or a phrase. Wildcards can be added to the
simple word parameters only, e.g. \code{q=*puma*}}

\item{country}{NOT YET IMPLEMENTED. Filters by country as given in
isocodes$gbif_name, e.g. \code{country="CANADA"}}

\item{type}{Type of dataset, options include occurrene, metadata, checklist,
sampling_event
(http://gbif.github.io/gbif-api/apidocs/org/gbif/api/vocabulary/DatasetType.html)}

\item{keyword}{Keyword to search by. Datasets can be tagged by keywords,
which you can search on. The search is done on the merged collection of
tags, the dataset keywordCollections and temporalCoverages.}

\item{publishingOrg}{Publishing organization. A uuid string. See
\code{\link{organizations}}}

\item{hostingOrg}{Hosting organization. A uuid string. See
\code{\link{organizations}}}

\item{publishingCountry}{Publishing country. See options at
isocodes$gbif_name}

\item{decade}{Decade, e.g., 1980. Filters datasets by their temporal coverage
broken down to decades. Decades are given as a full year, e.g. 1880, 1960,
2000, etc, and will return datasets wholly contained in the decade as well
as those that cover the entire decade or more. Facet by decade to get the
break down, e.g. /search?facet=DECADE&facet_only=true (see example below)}

\item{facet}{A list of facet names used to retrieve the 100 most frequent
values for a field. Allowed facets are: datasetKey, highertaxonKey, rank,
status, extinct, habitat, and nameType. Additionally threat and
nomenclaturalStatus are legal values but not yet implemented, so data will
not yet be returned for them.}

\item{facetMincount}{Used in combination with the facet parameter. Set
\code{facetMincount={#}} to exclude facets with a count less than {#}}

\item{facetMultiselect}{Used in combination with the facet parameter. Set
facetMultiselect=true to still return counts for values that are not
currently filtered}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{pretty}{Print informative metadata using \code{\link{cat}}. Not easy
to manipulate output though.}

\item{return}{Defunct. All components are returned; index to the
one(s) you want}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A data.frame, list, or message printed to console (using
\code{pretty=TRUE}).
}
\description{
This function does not search occurrence data, only metadata on the datasets
that contain occurrence data.
}
\section{Repeat parmeter inputs}{

Some parameters can tak emany inputs, and treated as 'OR' (e.g., a or b or
c). The following take many inputs:
\itemize{
\item \code{type}
\item \code{keyword}
\item \code{publishingOrg}
\item \code{hostingOrg}
\item \code{publishingCountry}
\item \code{decade}
}
}

\examples{
\dontrun{
# Gets all datasets of type "OCCURRENCE".
dataset_search(type="OCCURRENCE", limit = 10)

# Fulltext search for all datasets having the word "amsterdam" somewhere in
# its metadata (title, description, etc).
dataset_search(query="amsterdam", limit = 10)

# Limited search
dataset_search(type="OCCURRENCE", limit=2)
dataset_search(type="OCCURRENCE", limit=2, start=10)

# Return metadata in a more human readable way (hard to manipulate though)
dataset_search(type="OCCURRENCE", pretty=TRUE, limit = 10)

# Search by country code. Lookup isocodes first, and use US for United States
isocodes[agrep("UNITED", isocodes$gbif_name),]
dataset_search(country="US", limit = 10)

# Search by decade
dataset_search(decade=1980, limit = 10)

# Faceting
## just facets
dataset_search(facet="decade", facetMincount="10", limit=0)

## data and facets
dataset_search(facet="decade", facetMincount="10", limit=2)

# Some parameters accept many inputs, treated as OR
dataset_search(type = c("metadata", "checklist"))$data
dataset_search(keyword = c("fern", "algae"))$data
dataset_search(publishingOrg = c("e2e717bf-551a-4917-bdc9-4fa0f342c530",
  "90fd6680-349f-11d8-aa2d-b8a03c50a862"))$data
dataset_search(hostingOrg = c("c5f7ef70-e233-11d9-a4d6-b8a03c50a862",
  "c5e4331-7f2f-4a8d-aa56-81ece7014fc8"))$data
dataset_search(publishingCountry = c("DE", "NZ"))$data
dataset_search(decade = c(1910, 1930))$data

## curl options
dataset_search(facet="decade", facetMincount="10", limit=2,
  curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/registry#datasetSearch}
}
