% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_meta.R
\name{occ_download_meta}
\alias{occ_download_meta}
\title{Retrieves the occurrence download metadata by its unique key.}
\usage{
occ_download_meta(key, curlopts = list())
}
\arguments{
\item{key}{A key generated from a request, like that from
\code{occ_download}}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
an object of class \code{occ_download_meta}, a list with slots for
the download key, the DOI assigned to the download, license link,
the request details you sent in the \code{occ_download()} request,
and metadata about the size and date/time of the request
}
\description{
Retrieves the occurrence download metadata by its unique key.
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
occ_download_meta(key="0003983-140910143529206")
occ_download_meta("0000066-140928181241064")
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cached}()},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
