% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_cached.R
\name{occ_download_cached}
\alias{occ_download_cached}
\title{Check for downloads already in your GBIF account}
\usage{
occ_download_cached(
  ...,
  body = NULL,
  type = "and",
  format = "DWCA",
  user = NULL,
  pwd = NULL,
  email = NULL,
  refresh = FALSE,
  age = 30,
  curlopts = list()
)
}
\arguments{
\item{...}{For \code{occ_download()} and \code{occ_download_prep()}, one or more
objects of class \code{occ_predicate} or \code{occ_predicate_list}, created by
\verb{pred*} functions (see \link{download_predicate_dsl}). If you use this, don't
use \code{body} parameter.}

\item{body}{if you prefer to pass in the payload yourself, use this
parameter. If you use this, don't pass anything to the dots. Accepts
either an R list, or JSON. JSON is likely easier, since the JSON
library \pkg{jsonlite} requires that you unbox strings that shouldn't
be auto-converted to arrays, which is a bit tedious for large queries.
optional}

\item{type}{(character) One of equals (=), and (&), or (|), lessThan (<),
lessThanOrEquals (<=), greaterThan (>), greaterThanOrEquals (>=), in,
within, not (!), like, isNotNull}

\item{format}{(character) The download format. One of 'DWCA' (default),
'SIMPLE_CSV', or 'SPECIES_LIST'}

\item{user}{(character) User name within GBIF's website. Required. See
"Authentication" below}

\item{pwd}{(character) User password within GBIF's website. Required. See
"Authentication" below}

\item{email}{(character) Email address to receive download notice done
email. Required. See "Authentication" below}

\item{refresh}{(logical) refresh your list of downloads. on the first
request of each R session we'll cache your stored GBIF occurrence
downloads locally. you can refresh this list by setting \code{refresh=TRUE};
if you're in the same R session, and you've done many download requests,
then refreshing may be a good idea if you're using this function}

\item{age}{(integer) number of days after which you want a new
download. default: 30}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\description{
Check for downloads already in your GBIF account
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
# these are examples from the package maintainer's account;
# outcomes will vary by user
occ_download_cached(pred_gte("elevation", 12000L))
occ_download_cached(pred("catalogNumber", 217880))
occ_download_cached(pred_gte("decimalLatitude", 65),
  pred_lte("decimalLatitude", -65), type="or")
occ_download_cached(pred_gte("elevation", 12000L))
occ_download_cached(pred_gte("elevation", 12000L), refresh = TRUE)
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
