% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_parse.R
\name{name_parse}
\alias{name_parse}
\title{Parse taxon names using the GBIF name parser.}
\usage{
name_parse(scientificname, curlopts = list(http_version = 2))
}
\arguments{
\item{scientificname}{A character vector of scientific names.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A \code{data.frame} containing fields extracted from parsed
taxon names. Fields returned are the union of fields extracted from
all species names in \code{scientificname}.
}
\description{
Parse taxon names using the GBIF name parser.
}
\examples{
\dontrun{
name_parse(scientificname='x Agropogon littoralis')
name_parse(c('Arrhenatherum elatius var. elatius',
             'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
             'Vanessa atalanta (Linnaeus, 1758)'))
name_parse("Ajuga pyramidata")
name_parse("Ajuga pyramidata x reptans")

# Pass on curl options
# res <- name_parse(c('Arrhenatherum elatius var. elatius',
#          'Secale cereale subsp. cereale', 'Secale cereale ssp. cereale',
#          'Vanessa atalanta (Linnaeus, 1758)'), curlopts=list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/species#parser}
}
\author{
John Baumgartner (johnbb@student.unimelb.edu.au)
}
