% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profile}
\alias{profile}
\alias{position}
\title{Overview of User's System Profile}
\usage{
profile(api.key, secret, passphrase)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}
}
\value{
A dataframe with current status, system generated user id and profile id.
}
\description{
This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. This function takes no additional arguments and returns system identifiable information for the user and the status of the profile. If \code{active}, the profile can be used for trading. If \code{pending}, the profile is currently being created. If \code{locked}, the profile is undergoing a rebalance. If \code{default}, you were not able repay funding after a margin call or expired funding and now have a default. The complete \code{profile} response gets a lot of information which can be more easily fetched by \code{\link{accounts}}. This functions trims down the complete response only to the information that cannot be sought by other methods.
}
\examples{
\dontrun{
profile(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
}

}
