% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated.R
\name{ee_utils_gif_annotate}
\alias{ee_utils_gif_annotate}
\title{Add text to a GIF}
\usage{
ee_utils_gif_annotate(
  image,
  text,
  gravity = "northwest",
  location = "+0+0",
  degrees = 0,
  size = 20,
  font = "sans",
  style = "normal",
  weight = 400,
  kerning = 0,
  decoration = NULL,
  color = NULL,
  strokecolor = NULL,
  boxcolor = NULL
)
}
\arguments{
\item{image}{magick image object returned by \code{\link[magick:editing]{magick::image_read()}} or \code{\link[magick:device]{magick::image_graph()}}}

\item{text}{character vector of length equal to 'image' or length 1}

\item{gravity}{string with \href{https://www.imagemagick.org/Magick++/Enumerations.html#GravityType}{gravity}
value from \link[magick:options]{gravity_types}.}

\item{location}{geometry string with location relative to \code{gravity}}

\item{degrees}{rotates text around center point}

\item{size}{font-size in pixels}

\item{font}{string with font family such as \code{"sans"}, \code{"mono"}, \code{"serif"},
\code{"Times"}, \code{"Helvetica"}, \code{"Trebuchet"}, \code{"Georgia"}, \code{"Palatino"} or \code{"Comic Sans"}.}

\item{style}{value of \link[magick:options]{style_types} for example \code{"italic"}}

\item{weight}{thickness of the font, 400 is normal and 700 is bold.}

\item{kerning}{increases or decreases whitespace between letters}

\item{decoration}{value of \link[magick:options]{decoration_types} for example \code{"underline"}}

\item{color}{a valid \href{https://www.imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}. Use \code{"none"} for transparency.}

\item{strokecolor}{a \href{https://www.imagemagick.org/Magick++/Color.html}{color string}
adds a stroke (border around the text)}

\item{boxcolor}{a \href{https://www.imagemagick.org/Magick++/Color.html}{color string}
for background color that annotation text is rendered on.}
}
\value{
A magick-image object
}
\description{
Add text to a GIF (magick-image object). This function is a wrapper around
\link[magick:painting]{image_annotate}.
}
\examples{
\dontrun{
library(rgee)

ee_Initialize()

col <- ee$ImageCollection("JRC/GSW1_1/YearlyHistory")$map(function(img) {
  year <- img$date()$get("year")
  yearImg <- img$gte(2)$multiply(year)
  despeckle <- yearImg$connectedPixelCount(15, TRUE)$eq(15)
  yearImg$updateMask(despeckle)$selfMask()$set("year", year)
})

appendReverse <- function(col) col$merge(col$sort('year', FALSE))

# -----------------------------------
# 1 Basic Animation - Ucayali Peru
# -----------------------------------

bgColor = "FFFFFF" # Assign white to background pixels.
riverColor = "0D0887" # Assign blue to river pixels.

## 1.1 Create the dataset
annualCol = col$map(function(img) {
  img$unmask(0)$
    visualize(min = 0, max = 1, palette = c(bgColor, riverColor))$
    set("year", img$get("year"))
})
basicAnimation <- appendReverse(annualCol)


## 1.2 Set video arguments
aoi <- ee$Geometry$Rectangle(-74.327, -10.087, -73.931, -9.327)
videoArgs = list(
  dimensions = 600, # Max dimension (pixels), min dimension is proportionally scaled.
  region = aoi,
  framesPerSecond = 10
)

## 1.2 Download, display and save the GIF!
animation <- ee_utils_gif_creator(basicAnimation, videoArgs, mode = "wb")
get_years <- basicAnimation$aggregate_array("year")$getInfo()
animation \%>\%
  ee_utils_gif_annotate("Ucayali, Peru") \%>\%
  ee_utils_gif_annotate(get_years, size = 15, location = "+90+40",
                        boxcolor = "#FFFFFF") \%>\%
  ee_utils_gif_annotate("created using {magick} + {rgee}",
                        size = 15, font = "sans",location = "+70+20") ->
  animation_wtxt
gc(reset = TRUE)
ee_utils_gif_save(animation_wtxt, path = paste0(tempfile(), ".gif"))
}
}
\seealso{
Other GIF functions: 
\code{\link{ee_utils_gif_creator}()},
\code{\link{ee_utils_gif_save}()}
}
\author{
Jeroen Ooms
}
\concept{GIF functions}
