% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie_functions.R
\name{grep_analysis}
\alias{grep_analysis}
\title{Grep-based GenIE analysis}
\usage{
grep_analysis(
  regions,
  replicates,
  required_match_left = 10,
  required_match_right = 10,
  min_mapq = 0,
  quiet = FALSE
)
}
\arguments{
\item{regions}{A data.frame defining GenIE regions.}

\item{replicates}{A data.frame defining GenIE replicates.}

\item{required_match_left}{The length of sequence to the left of the HDR site
that must exactly match to identify HDR or WT reads.}

\item{required_match_right}{The length of sequence to the right of the HDR
site that must exactly match to identify HDR or WT reads.}

\item{min_mapq}{The minimum mapping quality for reads to be included in the
analysis.}

\item{quiet}{If TRUE, then no messages are printing during the analysis.}
}
\description{
For each replicate associated with an input region, \code{grep_analysis}
searches for alleles matching the HDR or WT sequences, and returns statistics
that indicate whether the HDR:WT ratio differs in cDNA and gDNA.
}
\section{Details}{
 For a grep analysis, the regions parameter is a data.frame
  with a format as follows. All of the column names below must be specified.
  \tabular{lccccclll}{ name \tab sequence_name \tab start \tab end \tab
  highlight_site \tab cut_site \tab hdr_allele_profile \tab wt_allele_profile
  \tab ref_sequence \cr MUL1_rs6700034  \tab MUL1  \tab 1 \tab 21 \tab 11
  \tab 9 \tab ----------A---------- \tab ----------C---------- \tab
  ACCGCACCCCCCCGGCCTAAC \cr }

\tabular{rl}{
  \strong{name} \tab A unique identifier for the region. \cr
  \strong{sequence_name} \tab The chromosome or amplicon sequence name. \cr
  \strong{start} \tab The start coordinate of the amplicon relative to the chromosome or amplicon reference. \cr
  \strong{end} \tab The end coordinate of the amplicon relative to the chromosome or amplicon reference (the end coordinate is included in the region). \cr
  \strong{highlight_site} \tab The relative position of the site of interest, usually the HDR SNP site. \cr
  \strong{cut_site} \tab The relative position of the cut site. \cr
  \strong{ref_sequence} \tab The reference sequence for the amplicon region, which must have length (end - start + 1). \cr
  \strong{hdr_allele_profile} \tab An allele profile describing the HDR allele. See details below. \cr
  \strong{wt_allele_profile} \tab An allele profile describing the WT allele. See details below. \cr
}

If multiple rows are defined for `regions`, then a separate analysis is run
for each region, using matched replicates from `replicates`.

The allele_profile columns indicate the positions in the amplicon sequence
that must match a given nucleotide for a read to be considered either HDR
or WT. This sequence must be the same length as the reference sequence,
and all other positions should be "-". The total sequence region that must
match is determined by both the positions of specified nucleotides and by
the \strong{required_match_left} and \strong{required_match_right}
parameters. These parameters give the length of sequence which must match
the provided reference sequence to the left of the leftmost specified
nucleotide, or to the right of the rightmost specified nucleotide.


The replicates parameter is a data.frame with a format as below.
\tabular{lccl}{ name \tab replicate \tab type \tab bam \cr MUL1_rs6700034
\tab c1.2 \tab cDNA \tab
bam_amplicon/MUL1_rs6700034_cDNA_rep1_pcr2.sortedByCoord.bam \cr
MUL1_rs6700034 \tab c1.3 \tab cDNA \tab
bam_amplicon/MUL1_rs6700034_cDNA_rep1_pcr3.sortedByCoord.bam \cr }

\tabular{rl}{
  \strong{name} \tab Indicates the region that a given replicate
  corresponds with. All replicates matching the name in the regions table
  will be used. \cr
  \strong{replicate} \tab an ID for the replicate, which must
  be unique among replicates for the region. \cr
  \strong{type} \tab Must have the value "cDNA" or "gDNA", indicating
  whether a given replicate contains data for cDNA or gDNA. \cr
  \strong{bam} \tab the path (relative to the working directory) to
  a BAM file with sequencing reads for the replicate. \cr
}

Statistics can only be computed if there are at least 2 replicates of each
type (cDNA and gDNA). Replicates are matched to the region based on the
\strong{name} column.
}

\section{Results}{
 The returned object is a list, where each item is the
result for one region. The result for a region (e.g. results[[1]]) is itself
a list, with the following items:
\tabular{rl}{
  \strong{region_stats} \tab Main analysis output, with statistics indicating whether the HDR/WT levels differ in cDNA relative to gDNA. \cr
  \strong{replicate_stats} \tab A data.frame with a row for each replicate, which has counts of reads in different categories and some summary values. \cr
  \strong{region} \tab 	Details of the input region the result corresponds to. \cr
  \strong{replicates} \tab Details of the input replicates the result corresponds to. \cr
  \strong{opts} \tab A list containing the options that were given for the analysis. \cr
  \strong{type} \tab Has the value “grep_analysis”, and is used by plotting functions that take a full grep_result list as input. \cr
}

The main output of interest is the `region_stats` field, which is a one-row data.frame with the following values:

\tabular{rl}{
  \strong{name} \tab Name of the region. \cr
  \strong{effect} \tab Estimated effect size - the amount by which the HDR:WT ratio differs in cDNA relative to gDNA. \cr
  \strong{effect_sd} \tab Standard deviation of the estimated effect size. \cr
  \strong{effect_confint_lo} \tab Lower bound of the 95\% confidence interval for the effect size. \cr
  \strong{effect_confint_hi} \tab Upper bound of the 95\% confidence interval for the effect size. \cr
  \strong{df_estimated} \tab The degrees of freedom used in the unequal variances t-test, which is estimated from the data. \cr
  \strong{pval} \tab A p value from the unequal variants t-test. \cr
}
}

\examples{
# Note: to run an analysis you need BAM files from a GenIE experiment.
# An example is available for download using download_example().

\donttest{
download_example(dir = "~/genie_example", name = "MUL1")
# Data are downloaded and we can run an rgenie analysis
setwd("~/genie_example/MUL1/")
regions = readr::read_tsv("mul1.genie_regions.tsv")
replicates = readr::read_tsv("mul1.genie_replicates.tsv")
grep_results = grep_analysis(regions, replicates)
grep_summary_plot(grep_results[[1]])
}
}
\seealso{
\code{\link{deletion_analysis}}

\code{\link{grep_summary_plot}}
}
