% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_multigeary}
\alias{local_multigeary}
\title{Local Multivariate Geary Statistics}
\usage{
local_multigeary(
  w,
  data,
  permutations = 999,
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{data}{A list of numeric values of selected variables}

\item{permutations}{The number of permutations for the LISA computation}

\item{significance_cutoff}{A cutoff value for significance p-values to filter not-significant clusters}

\item{cpu_threads}{The number of cpu threads used for parallel LISA computation}

\item{seed}{The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply local Multivariate Geary statistics
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
data <- guerry_df[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
lisa <- local_multigeary(queen_w, data)
lms <- lisa_clusters(lisa)
lms
}
