% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{min_distthreshold}
\alias{min_distthreshold}
\title{Minimum Distance Threshold for Distance-based Weights}
\usage{
min_distthreshold(geoda_obj, is_arc = FALSE, is_mile = TRUE)
}
\arguments{
\item{geoda_obj}{An object of [geoda] class}

\item{is_arc}{(optional) FALSE (default) or TRUE, compute arc distance between two observations}

\item{is_mile}{(optional) TRUE (default) or FALSE, convert distance unit from mile to km.}
}
\value{
A numeric value of minimum threshold of distance
}
\description{
Get minimum threshold of distance that makes sure each observation has at least one neighbor
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
dist_thres <- min_distthreshold(guerry)
dist_thres
}
}
