% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{spatial_lag}
\alias{spatial_lag}
\title{Spatial Lag}
\usage{
spatial_lag(gda_w, idx, values)
}
\arguments{
\item{gda_w}{A Weight object}

\item{idx}{A value indicates idx-th observation, idx start from 1}

\item{values}{A vector of values}
}
\value{
A numeric value of the spatial lag for idx-th observation
}
\description{
Compute the spatial lag for idx-th observation using selected variable and current weights matrix
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
lag0 <- spatial_lag(queen_w, idx = 1, values = crm_prs)
cat("\nSpatial lag of the 1-st observation of variable crm_prs is:", lag0)
}
}
