% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{standardize}
\alias{standardize}
\title{Standardize Data (Z)}
\usage{
standardize(data)
}
\arguments{
\item{data}{A list of numeric vectors (multi-variables) for standardization}
}
\value{
A list of numeric vectors from standardization (Z)
}
\description{
Standarize data by transforming data to have zero mean and unit variance
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
crm_prp <- guerry_df['Crm_prp'][,1] # get values of variable "crm_prp"
data <- list(crm_prs, crm_prp)
standardize(data)
}
