% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{spatial_validation}
\alias{spatial_validation}
\title{Spatial Validation}
\usage{
spatial_validation(sf_obj, clusters, w)
}
\arguments{
\item{sf_obj}{An sf (simple feature) object}

\item{clusters}{A cluster classification variable (categorical values from a dataframe or values returned from cluster functions)}

\item{w}{An instance of Weight class}
}
\value{
A list with names "Is Spatially Constrained", "Fragmentation", "Join Count Ratio",
"Compactness", and "Diameter".
}
\description{
Spatial validation provides a collection of validation measures including
1. fragmentations (entropy, simpson), 2. join count ratio, 3. compactness (isoperimeter quotient) 
and 4. diameter.
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
clusters <- skater(5, queen_w, data)
results <- spatial_validation(guerry, clusters, queen_w)
results
}
}
