% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{percentile_breaks}
\alias{percentile_breaks}
\title{Percentile Breaks}
\usage{
percentile_breaks(df)
}
\arguments{
\item{df}{A data frame with selected variable. E.g. guerry["Crm_prs"]}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Percentile breaks data into 6 groups: the lowest 1%, 1-10%, 10-50%, 50-90%, 90-99% and the top 1%.
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
percentile_breaks(guerry['Crm_prs'])
}
