% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipinfo.R
\name{ip_info}
\alias{ip_info}
\title{Geolocate IP Addresses Through ipinfo.io}
\usage{
ip_info(ip_addresses, token = NULL)
}
\arguments{
\item{ip_addresses}{a character vector of IP addresses}

\item{token}{optionally, an API token. If you don't use one, you
can still use the system, but requests will be capped to 1,000 a day.}
}
\value{
either a data.frame containing the geolocated information.
If an IP cannot be geolocated, or values are not available, the
fields will be filled with \code{NA} values.
}
\description{
\code{ip_info} consumes a vector of IP addresses
and geolocates them via \href{https://ipinfo.io}{ipinfo.io}.
}
\examples{
\dontrun{
#Valid, data.frame output
result <- ip_info("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93")

#Invalid, data.frame output
result <- ip_info("argh")

#Valid list output
result <- ip_info("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93", as_data_frame = FALSE)

#Invalid list output
result <- ip_info("argh", as_data_frame = FALSE)
}
}
\seealso{
\code{\link{ip_api}} and \code{\link{db_ip}} for other
online geolocation APIs.
}
