% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-witness.R
\name{StrongWitnessComplex}
\alias{StrongWitnessComplex}
\title{R6 Class for Strong Witness Complex}
\description{
A Witness complex \eqn{\mathrm{Wit}(W,L)} is a simplicial
complex defined on two sets of points in \eqn{R^D}. The data structure is
described in \insertCite{boissonnat2014simplex;textual}{rgudhi}.
}
\details{
The class constructs a (strong) witness complex for a given table of
nearest landmarks with respect to witnesses.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
withr::with_seed(1234, {
  l <- list(
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    ),
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    )
  )
})
wc <- StrongWitnessComplex$new(nearest_landmark_table = l)
wc
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{\link[rgudhi:WitnessComplex]{rgudhi::WitnessComplex}} -> \code{StrongWitnessComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StrongWitnessComplex-new}{\code{StrongWitnessComplex$new()}}
\item \href{#method-StrongWitnessComplex-clone}{\code{StrongWitnessComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="WitnessComplex" data-id="create_simplex_tree"><a href='../../rgudhi/html/WitnessComplex.html#method-WitnessComplex-create_simplex_tree'><code>rgudhi::WitnessComplex$create_simplex_tree()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StrongWitnessComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-StrongWitnessComplex-new}{}}}
\subsection{Method \code{new()}}{
\code{StrongWitnessComplex} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StrongWitnessComplex$new(nearest_landmark_table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nearest_landmark_table}}{A list of \code{\link[tibble]{tibble}}s
specifying for each \emph{witness} \code{w}, the ordered list of nearest
landmarks with id in column \code{nearest_landmark} and distance to \code{w} in
column \code{distance}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{StrongWitnessComplex}} object storing the strong
Witness complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StrongWitnessComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StrongWitnessComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StrongWitnessComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
