% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocodePL_get.R
\name{geocodePL_get}
\alias{geocodePL_get}
\title{returns a sf data.frame with metadata for a given type of input
(geocoding addresses and objects)}
\usage{
geocodePL_get(
  address = NULL,
  road = NULL,
  rail_crossing = NULL,
  geoname = NULL
)
}
\arguments{
\item{address}{place with or without street and house number}

\item{road}{road number with or without mileage}

\item{rail_crossing}{rail crossing identifier
(11 characters including 2 spaces, format: "XXX XXX XXX")}

\item{geoname}{name of the geographical object from State Register
of Geographical Names (function \code{\link[=geonames_download]{geonames_download()}})}
}
\value{
a sf data.frame (EPSG: 2180) with metadata
}
\description{
returns a sf data.frame with metadata for a given type of input
(geocoding addresses and objects)
}
\examples{
\dontrun{
geocodePL_get(address = "Marki") # place
geocodePL_get(address = "Marki, Andersa") # place and street
geocodePL_get(address = "Marki, Andersa 1") # place, street and house number
geocodePL_get(address = "Królewskie Brzeziny 13") # place and house number

geocodePL_get(road = "632") # road number
geocodePL_get(road = "632 55") # road number and mileage

geocodePL_get(rail_crossing = "001 018 478")

geocodePL_get(geoname = "Las Mierzei") # physiographic object
}
}
