% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalisedKinship.R
\name{generalisedKinship}
\alias{generalisedKinship}
\title{Generalised kinship coefficients}
\usage{
generalisedKinship(x, pattern, mem = NULL, verbose = FALSE,
  debug = FALSE)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{pattern}{A \code{kinPattern} object.}

\item{mem}{An \code{environment} (for internal use).}

\item{verbose}{A logical.}

\item{debug}{A logical.}
}
\value{
A single probability.
}
\description{
Compute generalised single-locus kinship coefficients, using the algorithm by
Weeks & Lange (1988).
}
\examples{
x = nuclearPed(3)
kp = kinPattern(x, list(c(1,1,1)))
generalisedKinship(x, kp)


##### IBD coefficients via generalised kinship ###
#(Clearly not the simplest way; serves as a check)
IBD_from_gk = function(x, ids) {
  fa1 = father(x, ids[1])
  fa2 = father(x, ids[2])
  mo1 = mother(x, ids[1])
  mo2 = mother(x, ids[2])
  GK = function(...) generalisedKinship(x, list(...))

  k0 = GK(fa1, fa2, mo1, mo2)
  k1 = GK(c(fa1, fa2), mo1, mo2) + GK(c(fa1, mo2), fa2, mo1) +
       GK(c(mo1, fa2), fa1, mo2) + GK(c(mo1, mo2), fa1, fa2)
  k2 = GK(c(fa1, fa2), c(mo1, mo2)) + GK(c(fa1, mo2), c(mo1, fa2))
  c(k0, k1, k2)
}

y1 = nuclearPed(2); ids = 3:4
stopifnot(IBD_from_gk(y1, ids) == kappaIBD(y1, ids))

y2 = quadHalfFirstCousins()
ids = 9:10
stopifnot(IBD_from_gk(y2, ids) == kappaIBD(y2, ids))

#### Triple/quad kinship (compare with karigl)
x = fullSibMating(1)
ids = c(1,5,6)
stopifnot(generalisedKinship(x, list(ids)) == generalisedKinship3(x, ids))
ids = c(1,5,6,5)
stopifnot(generalisedKinship(x, list(ids)) == generalisedKinship4(x, ids))

}
\references{
Weeks and Lange. \emph{The Affected-Pedigree-Member Method of Linkage
Analysis}. Am. J. Hum. Genet. 42:315-326, 1988.
}
