% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqmsg.R
\name{qqmsg}
\alias{qqmsg}
\title{Quitely Quit with Messages}
\usage{
qqmsg(..., status = 0, save = FALSE, runLast = TRUE)
}
\arguments{
\item{\dots}{Messages to be passed to \code{message}}

\item{status}{Quit stats}

\item{save}{Logical, should current working environment be saved?}

\item{runLast}{Logical, should \code{.Last()} be executed?}
}
\value{
Invisible \code{NULL}, only side effect is used.
}
\description{
Quitely quit R with messages in non-interactive sessions
}
\details{
The function prints messages in any case, and quits R if the current session
is non-interactive, e.g. in the command-line running Rscript mode
}
\examples{

## the example should not run because it will lead the R session to quit
\dontrun{
  qqmsg()
  qqmsg("die", status=0)
  qqmsg("Avada kedavra", status=-1)
  qqmsg("Crucio!", "\n", "Avada kedavra", status=-100)
}

}
\seealso{
\code{\link{quit}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
