% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{spread}
\alias{spread}
\title{The spread among calibrated dates}
\usage{
spread(
  y,
  er,
  n = 1e+05,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  as.F = FALSE,
  thiscurve = NULL,
  yrsteps = 1,
  cc.resample = FALSE,
  threshold = 0.001,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  cc.dir = NULL,
  visualise = TRUE,
  talk = TRUE,
  prob = 0.95,
  roundby = 1,
  bty = "l"
)
}
\arguments{
\item{y}{The set of radiocarbon dates}

\item{er}{The lab errors of the radiocarbon dates}

\item{n}{The number of iterations to base the calculations on. Defaults to 100,000.}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{as.F}{Whether or not to calculate ages in the F14C realm. Defaults to \code{as.F=FALSE}, which uses the C14 realm.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{cc.resample}{The IntCal20 curves have different densities (every year between 0 and 5 kcal BP, then every 5 yr up to 15 kcal BP, then every 10 yr up to 25 kcal BP, and then every 20 yr up to 55 kcal BP). If calibrated ages span these density ranges, their drawn heights can differ, as can their total areas (which should ideally all sum to the same size). To account for this, resample to a constant time-span, using, e.g., cc.resample=5 for 5-yr timespans.}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{visualise}{Whether or not to plot the spread}

\item{talk}{Whether or not to report a summary of the spread}

\item{prob}{Probability range to report. Defaults to \code{prob=0.95}.}

\item{roundby}{Number of decimals to report}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}
}
\value{
The spread of all calibrated probabilities.
}
\description{
Calculates the spread among multiple calibrated radiocarbon dates. It does this by randomly sampling ages from the calibrated dates, and calculate the difference between one random date and all others for that iteration.
}
\examples{
  data(shroud)
  spread(shroud$y,shroud$er)
  Zu <- grep("ETH", shroud$ID) # Zurich lab only
  spread(shroud$y[Zu],shroud$er[Zu])
}
