% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{compute_weighted_ecdf}
\alias{compute_weighted_ecdf}
\title{Weighted ECDF value}
\usage{
compute_weighted_ecdf(dep_var, weights)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.}
}
\value{
the values of ECDF for a vector \code{dep_var}.
}
\description{
Compute values of the ECDF for a vector \code{dep_var} (i.e. the
empirical probability for each observation in \code{dep_var} that a value
in \code{dep_var} is smaller or equal).
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
value_of_ecdf <-
  compute_weighted_ecdf(
    dep_var = dep_var,
    weights = weights
  )

}
