% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{rim-package}
\alias{rim}
\alias{rim-package}
\alias{maxima.start}
\alias{maxima.stop}
\alias{maxima.get}
\alias{maxima.load}
\alias{maxima.apropos}
\alias{maxima.setformat}
\alias{maxima.getformat}
\alias{maxima.version}
\alias{iprint}
\alias{print.maxima}
\title{rim}
\usage{
maxima.start(restart = FALSE)

maxima.stop()

maxima.get(command)

maxima.load(module)

maxima.apropos(keystring)

maxima.setformat(format = "linear")

maxima.getformat()

maxima.version()

iprint(x)

\method{print}{maxima}(x, ...)
}
\arguments{
\item{restart}{If FALSE (default), then Maxima is started provided it is not running already. If TRUE starts or restarts Maxima.}

\item{command}{A character vector containing the maxima command.}

\item{module}{A character vector naming the maxima module to be loaded.}

\item{keystring}{A character vector containing a search term.}

\item{format}{A character vector naming the output display format. Can be one of "linear" (default), "text2d", "latex" (i.e. $$...$$), "mathml".}

\item{label}{Logical (FALSE). Returns character vector including output label (TRUE). If FALSE (default), return character vector without output label.}
}
\description{
Provides an interface to Maxima, a computer algebra system.
}
\details{
Note: You need to install the Maxima software separately in order to make use of this package. 

Maxima is set up automatically on attachment via \code{library(rim)} and automatically started when a command is send (if it isn't running already) using \code{maxima.get()}. Using \code{maxima.start()} and \code{maxima.stop()}, one can stop and (re-)start the current Maxima session if needed, e.g. to clear Maxima command and output history.

To send a single command to Maxima and receive the corresponding output use \code{maxima.get()}. The output is returned in the format currently set (\code{maxima.getformat()}). The format can be changed using \code{maxima.setformat())}.
}
\section{Functions}{
\itemize{
\item \code{maxima.start}: (re-)starts Maxima.

\item \code{maxima.stop}: Quits Maxima.

\item \code{maxima.get}: Executes a single Maxima command provided by \code{command}. If no command ending character (\code{;} or \code{$} is provided, \code{;} is appended.

\item \code{maxima.load}: A wrapper to load a Maxima module named by \code{module}

\item \code{maxima.apropos}: A wrapper to the Maxima helper function \code{apropos} to lookup existing Maxima functions that match \code{keystring}.

\item \code{maxima.setformat}: Sets the format of the output string from Maxima.

\item \code{maxima.getformat}: Returns the currently set format as a character vector

\item \code{maxima.version}: Returns the version number of Maxima that is used

\item \code{iprint}: Prints the input command preceding with the corresponding input reference label of an maxima S3-object returned by maxima.get()

\item \code{print.maxima}: Prints the maxima output part of an S3 object returned by maxima.get()
}}

\seealso{
Useful links:
\itemize{
  \item \url{https://rcst.github.io/rim/}
  \item Report bugs at \url{https://github.com/rcst/rim/issues}
}


\code{\link{maxima.engine}}
}
\author{
\strong{Maintainer}: Eric Stemmler \email{stemmler.eric@gmail.com}

Authors:
\itemize{
  \item Kseniia Shumelchyk \email{shumelchyk@gmail.com}
  \item Hans W. Borchers \email{hwborchers@googlemail.com}
}

}
\keyword{internal}
