% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoflow.R
\name{info_flow}
\alias{info_flow}
\title{Information Flow}
\usage{
info_flow(src, dst, back = NULL, lsrc, ldst, lback = 0)
}
\arguments{
\item{src}{Vector or matrix specifying one or more source time series.}

\item{dst}{Vector or matrix specifying one or more destination time series.}

\item{back}{Vector or matrix specifying one or more background time series.}

\item{lsrc}{Integer giving the number of sources.}

\item{ldst}{Integer giving the number of destinations.}

\item{lback}{Integer giving the number of backgrounds.}
}
\value{
Numeric giving the value of information flow.
}
\description{
Compute the information flow from \code{lsrc} time series \code{src} to
another \code{ldst} time series \code{dst}. Optionally, the user can specify
\code{lback} background time series \code{back} to conditioning probabilities.
}
\examples{
# Information flow across four time series:
ws <- c(0, 0, 1, 0, 1, 1, 0, 1)
xs <- c(0, 0, 1, 0, 1, 1, 0, 1)
ys <- c(0, 0, 1, 0, 1, 1, 0, 1)
zs <- c(0, 0, 0, 0, 0, 0, 0, 0)

info_flow(src = xs, dst = ys, lsrc = 1, ldst = 1)                            # flow ~ 1.0
info_flow(src = xs, dst = ys, back = ws, lsrc = 1, ldst = 1, lback = 1)      # flow ~ 0.0
info_flow(src = ws, dst = zs, back = ys, lsrc = 1, ldst = 1, lback = 1)      # flow ~ 0.0

# Now let's intervene on ys and zs
ws <- c(0, 0, 1, 0, 1, 1, 0, 1)
xs <- c(0, 0, 1, 0, 1, 1, 0, 1)
ys <- c(1, 0, 1, 0, 0, 1, 1, 0)
zs <- c(1, 0, 0, 0, 1, 0, 1, 1)
info_flow(src = xs, dst = ys, lsrc = 1, ldst = 1)                            # flow ~ 0.0
info_flow(src = xs, dst = ys, back = ws, lsrc = 1, ldst = 1, lback = 1)      # flow ~ 0.0
info_flow(src = ws, dst = zs, back = ys, lsrc = 1, ldst = 1, lback = 1)      # flow ~ 1.0
}
