% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon_conditional_entropy}
\alias{shannon_conditional_entropy}
\title{Shannon Conditional Entropy}
\usage{
shannon_conditional_entropy(p_xy, p_y, b = 2)
}
\arguments{
\item{p_xy}{Dist specifying the joint distribution.}

\item{p_y}{Dist specifying the \code{y}-marginal distribution.}

\item{b}{Numeric giving the base of the logarithm.}
}
\value{
Numeric giving the Shannon conditional entropy.
}
\description{
Compute the base-\code{b} conditional entropy given joint \code{p_xy} and
marginal \code{p_y} distributions.
}
\examples{
xy <- Dist(c(10, 70, 15, 5))
x  <- Dist(c(80, 20))
y  <- Dist(c(25, 75))
shannon_conditional_entropy(xy, x)              # 0.5971072
shannon_conditional_entropy(xy, y)              # 0.5077571
shannon_conditional_entropy(xy, x, b = 3)       # 0.3767327
shannon_conditional_entropy(xy, y, b = 3)       # 0.3203591


}
