% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubical.R
\name{cubical}
\alias{cubical}
\alias{cubical.array}
\alias{cubical.matrix}
\title{Calculating Persistent Homology via a Cubical Complex}
\usage{
cubical(dataset, ...)

\method{cubical}{array}(dataset, threshold = 9999, method = "lj", ...)

\method{cubical}{matrix}(dataset, ...)
}
\arguments{
\item{dataset}{object on which to calculate persistent homology}

\item{...}{other relevant parameters}

\item{threshold}{maximum simplicial complex diameter to explore}

\item{method}{either \code{"lj"} (for Link Join) or \code{"cp"} (for Compute Pairs);
see Kaji et al. (2020) \url{https://arxiv.org/abs/2005.12692} for details}
}
\value{
\code{PHom} object
}
\description{
This function is an R wrapper for the CubicalRipser C++ library to calculate
persistent homology. For more information on the C++ library, see
\url{https://github.com/CubicalRipser}. For more information on how objects of
different classes are evaluated by \code{cubical}, read the Details section
below.
}
\details{
\code{cubical.array} assumes \code{dataset} is a lattice, with each element containing
the value of the lattice at the point represented by the indices of the
element in the \code{array}.

\code{cubical.matrix} is redundant for versions of \code{R} at or after 4.0. For
previous versions of \code{R}, in which objects with class \code{matrix} do not
necessarily also have class \code{array}, \code{dataset} is converted to an \code{array}
and persistent homology is then calculated using \code{cubical.array}.
}
\examples{

# 2-dim example
dataset <- rnorm(10 ^ 2)
dim(dataset) <- rep(10, 2)
cubical_hom2 <- cubical(dataset)

# 3-dim example
dataset <- rnorm(8 ^ 3)
dim(dataset) <- rep(8, 3)
cubical_hom3 <- cubical(dataset)

# 4-dim example
dataset <- rnorm(5 ^ 4)
dim(dataset) <- rep(5, 4)
}
