% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSplitMethod.R
\name{getSplitMethod}
\alias{getSplitMethod}
\title{Input for data splitting algorithms}
\usage{
getSplitMethod(split.method, B, N, M, seed)
}
\arguments{
\item{split.method}{A character string specifying the algorithm for data splitting:
\itemize{
\item{"loob"} leave one out bootstrap
\item{"bootcv"} bootstrap cross validation
\item{"cv5"} 5-fold cross validation
\item{"loocv"} leave one out cross validation aka N-1 fold cross validation 
\item{"632plus"} Efron's .632+ bootstrap
}}

\item{B}{Number of repetitions of bootstrap or k-fold cross-validation}

\item{N}{Sample size}

\item{M}{Subsample size. Default is N (no subsampling).}

\item{seed}{Integer passed to set.seed. If not given or NA no seed is set.}
}
\value{
A list with the following elements:
\itemize{
\item{split.methodName}: the print name of the algorithm
\item{split.method}: the internal name of the algorithm
\item{index}: the index for data splitting. For bootstrap splitting this
is a matrix with B columns and M rows identifying the in-bag subjects. For k-fold
cross-validation this is a matrix with B columns identifying the membership to the k groups.
\item{k}: the k of k-fold cross-validation
\item{N}: the sample size
\item{M}: the subsample size
}
}
\description{
Parse hyperparameters for data splitting algorithm
}
\examples{
# 3-fold crossvalidation
getSplitMethod("cv3",B=4,N=37)

# bootstrap with replacement
getSplitMethod("loob",B=4,N=37)

# bootstrap without replacement
getSplitMethod("loob",B=4,N=37,M=20)

}
\seealso{
Score
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
