% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.Score.R
\name{autoplot.Score}
\alias{autoplot.Score}
\title{ggplot AUC curve}
\usage{
\method{autoplot}{Score}(object, models, type = "score", lwd = 2, xlim,
  ylim, axes = TRUE, conf.int = FALSE, ...)
}
\arguments{
\item{object}{Object obtained with \code{Score.list}}

\item{models}{Choice of models to plot}

\item{type}{Character. Either \code{"score"} to show AUC or \code{"contrasts"} to show differences between AUC.}

\item{lwd}{Line width}

\item{xlim}{Limits for x-axis}

\item{ylim}{Limits for y-axis}

\item{axes}{Logical. If \code{TRUE} draw axes.}

\item{conf.int}{Logical. If \code{TRUE} draw confidence shadows.}

\item{...}{Not yet used}
}
\description{
ggplot AUC curves
}
\examples{
library(survival)
d=sampleData(100,outcome="survival")
nd=sampleData(100,outcome="survival")
f1=coxph(Surv(time,event)~X1+X6+X8,data=d,x=TRUE,y=TRUE)
f2=coxph(Surv(time,event)~X2+X5+X9,data=d,x=TRUE,y=TRUE)
xx=Score(list(f1,f2), formula=Surv(time,event)~1,
data=nd, metrics="auc", null.model=FALSE, times=seq(3:10))
aucgraph <- plotAUC(xx)
plotAUC(xx,conf.int=TRUE)
plotAUC(xx,which="contrasts")
plotAUC(xx,which="contrasts",conf.int=TRUE)


}
