% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_riverdistance.R
\name{riverdistancemat}
\alias{riverdistancemat}
\title{River Distance Matrix}
\usage{
riverdistancemat(seg, vert, rivers, logical = NULL, ID = NULL,
  stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{logical}{A boolean vector that can be used for subsetting.  If used,
\code{riverdistancemat} will only return pairwise distances in which a
specified condition is met.}

\item{ID}{a vector of observation IDs for aid in interpreting the output
table}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
A matrix of distances (numeric) with rows and columns labeled by corresponding values of \code{ID}.
}
\description{
Returns a matrix of distances between every point and every
  other point of given river locations (segment and vertex), or of a subset.
}
\note{
Building routes from the river mouth to each river network segment may greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)

logi1 <- (fakefish$flight.date==as.Date("2015-11-25"))

riverdistancemat(seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk, logical=logi1)
}
\author{
Matt Tyers
}
\seealso{
\link{riverdistance}
}

