prune <- function(net,x.up=NA,y.up=NA,x.dn=NA,y.dn=NA,verbose=TRUE) UseMethod("prune")

prune.rivernet <- function(net,x.up=NA,y.up=NA,x.dn=NA,y.dn=NA,verbose=TRUE)
{
  # get reaches to prune from:

  reachind.up <- NA; if ( !is.na(x.up[1]) ) reachind.up <- getreachind(net,x.up,y.up)[,1]
  reachind.dn <- NA; if ( !is.na(x.dn[1]) ) reachind.dn <- getreachind(net,x.dn,y.dn)[,1]
  
  if ( is.na(reachind.up[1]) & is.na(reachind.dn[1]) )
  {
    if ( verbose ) cat("*** no points found to prune at\n")
    return(net)
  }
  
  # get network structure:
  
  if ( length(net$paths) == 0 ) net <- analyze(net,verbose)
  
  # pruning network:

  remove.reach.up <- rep(FALSE,length(net$reaches))
  remove.reach.dn <- rep(FALSE,length(net$reaches))
  if ( !is.na(reachind.dn[1]) ) remove.reach.dn <- rep(TRUE,length(net$reaches))
  for ( i in 1:length(net$paths) )
  {
    if ( !is.na(reachind.up[1]) )
    {
      inds <- match(reachind.up,net$paths[[i]])
      if ( sum(!is.na(inds)) > 0 )
      {
        ind <- max(inds,na.rm=TRUE)
        remove.reach.up[net$paths[[i]][1:ind]] <- TRUE
      }
    }
    if ( !is.na(reachind.dn[1]) )
    {
      inds <- match(reachind.dn,net$paths[[i]])
      if ( sum(!is.na(inds)) > 0 )
      {
        ind <- max(inds,na.rm=TRUE)
        if ( ind > 1 ) remove.reach.dn[net$paths[[i]][1:(ind-1)]] <- FALSE
      }
    }
  }
  remove.node <- rep(FALSE,length(net$nodes))
  for ( i in 1:length(net$reaches) )
  {
    if ( remove.reach.up[i] )
    {
      remove.node[net$reaches[[i]]$from_node] <- TRUE
    }
    if ( remove.reach.dn[i] )
    {
      remove.node[net$reaches[[i]]$to_node] <- TRUE
      if ( is.na(match(i,reachind.dn)) )  # remove upstream nodes in side branches
      {
        remove.node[net$reaches[[i]]$from_node] <- TRUE
      }
    }
  }
  remove.reach <- remove.reach.up | remove.reach.dn
  if ( verbose )
  {
    cat("Deleting",sum(remove.reach),"of",length(net$reaches),"reaches \n")
    cat("Deleting",sum(remove.node),"of",length(net$nodes),"nodes\n")
  }
  if ( sum(!remove.reach) == 0 ) return(NA)
  nodeind          <- (1:length(net$nodes))[!remove.node]
  net$reaches      <- net$reaches[!remove.reach]
  net$nodes        <- net$nodes[!remove.node]
  net$attrib.reach <- net$attrib.reach[!remove.reach,]
  net$attrib.node  <- net$attrib.node[!remove.node,]
  # correct indices of start and end node of each reach:
  net$attrib.reach[,"node_start"] <- match(net$attrib.reach[,"node_start"],nodeind)
  net$attrib.reach[,"node_end"]   <- match(net$attrib.reach[,"node_end"],nodeind)
  
  # updating entries:
    
  net$total.length <- sum(net$attrib.reach[,"length"])
  x.min   <- NA
  x.max   <- NA
  y.min   <- NA
  y.max   <- NA
  z.min   <- NA
  z.max   <- NA
  for ( i in 1:length(net$reaches) )
  {
    x.min <- min(x.min,net$reaches[[i]]$x,na.rm=TRUE)
    y.min <- min(y.min,net$reaches[[i]]$y,na.rm=TRUE)
    z.min <- min(z.min,net$reaches[[i]]$z,na.rm=TRUE)
    x.max <- max(x.max,net$reaches[[i]]$x,na.rm=TRUE)
    y.max <- max(y.max,net$reaches[[i]]$y,na.rm=TRUE)
    z.max <- max(z.max,net$reaches[[i]]$z,na.rm=TRUE)
  }
  net$xlim <- c(x.min,x.max)
  net$ylim <- c(y.min,y.max)
  net$zlim <- c(z.min,z.max)
  net$htow <- (y.max-y.min)/(x.max-x.min)
  
  # reanalyzing network structure:
  
  net <- analyze(net,verbose=verbose)
  
  return(net)
}
  