% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{froude}
\alias{froude}
\title{Froude Number}
\usage{
froude(Q, g, A, DH)
}
\arguments{
\item{Q}{Flow rate [\eqn{L^3 T^{-1}}].}

\item{g}{Gravitational acceleration [\eqn{L T^{-2}}].}

\item{A}{Flow area [\eqn{L^2}].}

\item{DH}{Hydraulic depth [\eqn{L}].}
}
\value{
The Froude Number (dimensionless).
}
\description{
Calculate the Froude Number.
}
\details{
The Froude number is a dimensionless measure of bulk flow 
  characteristics that represents the relative importance of inertial 
  forces and gravitational forces. For open channel flow, the Froude 
  number of open channel flow is defined as \deqn{Fr = \frac{v}{\sqrt{gD_H}}} 
  where \eqn{v = \frac{Q}{A}} is the flow velocity, \eqn{g} is the gravitational 
  acceleration and \eqn{D_H} is the hydraulic depth. The Froude number is related
  to the energy state of the flow and can be used to identify flows as
  either supercritical (\eqn{Fr < 1}) or subcritical (\eqn{Fr > 1}).
}
\examples{
froude(250, 32.2, 171, 1.71) # subcritical flow
froude(250, 32.2, 57.9, 0.579) # critical flow
froude(250, 32.2, 45, 0.45) # supercritical flow
}

