% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_decomposition.R
\name{print_decomposition}
\alias{print_decomposition}
\title{Print the decomposition}
\usage{
print_decomposition(
  x,
  format = knitr::opts_knit$get("rmarkdown.pandoc.to"),
  plot = TRUE,
  digits = 3,
  decimal.mark = getOption("OutDec"),
  booktabs = TRUE,
  ...
)
}
\arguments{
\item{x}{the object to print.}

\item{format}{output format: \code{"latex"} or \code{"html"}.}

\item{plot}{boolean indicating whether to plot or not the S-I Ratio.}

\item{digits}{number of digits after the decimal point.}

\item{decimal.mark}{the character to be used to indicate the numeric decimal point.}

\item{booktabs}{boolean indicating whether to use or not the booktabs package (when \code{format = "latex"}).}

\item{...}{arguments passed to \code{\link[RJDemetra]{plot.decomposition_X11}} or \code{\link[RJDemetra]{plot.decomposition_SEATS}}.}
}
\description{
Function to print the decomposition model
}
\examples{
ipi <- RJDemetra::ipi_c_eu[, "FR"]

jsa_x13 <- RJDemetra::jx13(ipi)
print_decomposition(jsa_x13, format = "latex")

\donttest{
sa_ts <- RJDemetra::jtramoseats(ipi)
print_decomposition(sa_ts, format = "html")
}

}
