% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_expr}
\alias{parse_expr}
\alias{parse_exprs}
\alias{parse_quosure}
\alias{parse_quosures}
\title{Parse R code}
\usage{
parse_expr(x)

parse_exprs(x)

parse_quosure(x, env = caller_env())

parse_quosures(x, env = caller_env())
}
\arguments{
\item{x}{Text containing expressions to parse_expr for
\code{parse_expr()} and \code{parse_exprs()}. Can also be an R connection,
for instance to a file. If the supplied connection is not open,
it will be automatically closed and destroyed.}

\item{env}{The environment for the formulas. Defaults to the
context in which the parse_expr function was called. Can be any
object with a \code{as_env()} method.}
}
\value{
\code{parse_expr()} returns a formula, \code{parse_exprs()} returns a
list of formulas.
}
\description{
These functions parse and transform text into R expressions. This
is the first step to interpret or evaluate a piece of R code
written by a programmer.
}
\details{
\code{parse_expr()} returns one expression. If the text contains more
than one expression (separated by colons or new lines), an error is
issued. On the other hand \code{parse_exprs()} can handle multiple
expressions. It always returns a list of expressions (compare to
\code{\link[base:parse]{base::parse()}} which returns an base::expression vector). All
functions also support R connections.

The versions prefixed with \code{f_} return expressions quoted in
formulas rather than raw expressions.
}
\examples{
# parse_expr() can parse_expr any R expression:
parse_expr("mtcars \%>\% dplyr::mutate(cyl_prime = cyl / sd(cyl))")

# A string can contain several expressions separated by ; or \\n
parse_exprs("NULL; list()\\n foo(bar)")

# The versions suffixed with _f return formulas:
parse_quosure("foo \%>\% bar()")
parse_quosures("1; 2; mtcars")

# The env argument is passed to as_env(). It can be e.g. a string
# representing a scoped package environment:
parse_quosure("identity(letters)", env = empty_env())
parse_quosures("identity(letters); mtcars", env = "base")


# You can also parse source files by passing a R connection. Let's
# create a file containing R code:
path <- tempfile("my-file.R")
cat("1; 2; mtcars", file = path)

# We can now parse it by supplying a connection:
parse_exprs(file(path))
}
\seealso{
\code{\link[base:parse]{base::parse()}}
}
