% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-restarts.R
\name{rst_abort}
\alias{rst_abort}
\title{Jump to the abort restart}
\usage{
rst_abort()
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("questioning")}

The abort restart is the only restart that is established at top
level. It is used by R as a top-level target, most notably when an
error is issued (see \code{\link[=abort]{abort()}}) that no handler is able
to deal with (see \code{\link[=with_handlers]{with_handlers()}}).
}
\section{Life cycle}{


All the restart functions are in the questioning stage. It is not
clear yet whether we want to recommend restarts as a style of
programming in R.
}

\examples{
# The `abort` restart is a bit special in that it is always
# registered in a R session. You will always find it on the restart
# stack because it is established at top level:
rst_list()

# You can use the `above` restart to jump to top level without
# signalling an error:
\dontrun{
fn <- function() {
  cat("aborting...\\n")
  rst_abort()
  cat("This is never called\\n")
}
{
  fn()
  cat("This is never called\\n")
}
}

# The `above` restart is the target that R uses to jump to top
# level when critical errors are signalled:
\dontrun{
{
  abort("error")
  cat("This is never called\\n")
}
}

# If another `abort` restart is specified, errors are signalled as
# usual but then control flow resumes with from the new restart:
\dontrun{
out <- NULL
{
  out <- with_restarts(abort("error"), abort = function() "restart!")
  cat("This is called\\n")
}
cat("`out` has now become:", out, "\\n")
}
}
\seealso{
\code{\link[=rst_jump]{rst_jump()}}, \code{\link[=abort]{abort()}}
}
