% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-entrace.R
\name{entrace}
\alias{entrace}
\alias{cnd_entrace}
\title{Add backtrace from error handler}
\usage{
entrace(cnd, ..., top = NULL, bottom = NULL)

cnd_entrace(cnd, ..., top = NULL, bottom = NULL)
}
\arguments{
\item{cnd}{When \code{entrace()} is used as a calling handler, \code{cnd} is
the condition to handle.}

\item{...}{Unused. These dots are for future extensions.}

\item{top}{The first frame environment to be included in the
backtrace. This becomes the top of the backtrace tree and
represents the oldest call in the backtrace.

This is needed in particular when you call \code{trace_back()}
indirectly or from a larger context, for example in tests or
inside an RMarkdown document where you don't want all of the
knitr evaluation mechanisms to appear in the backtrace.}

\item{bottom}{The last frame environment to be included in the
backtrace. This becomes the rightmost leaf of the backtrace tree
and represents the youngest call in the backtrace.

Set this when you would like to capture a backtrace without the
capture context.

Can also be an integer that will be passed to \code{\link[=caller_env]{caller_env()}}.}
}
\description{
\code{entrace()} interrupts an error throw to add an \link[=trace_back]{rlang backtrace} to the error. The error throw is
immediately resumed. \code{cnd_entrace()} adds a backtrace to a
condition object, without any other effect. Both functions should
be called directly from an error handler.

Set the \code{error} global option to \code{quote(rlang::entrace())} to
transform base errors to rlang errors. These enriched errors
include a backtrace. The RProfile is a good place to set the
handler. See \code{\link{rlang_backtrace_on_error}} for details.

\code{entrace()} also works as a \link{calling} handler, though it
is often more practical to use the higher-level function
\code{\link[=with_abort]{with_abort()}}.
}
\examples{
if (FALSE) {  # Not run

# Set the error handler in your RProfile like this:
if (requireNamespace("rlang", quietly = TRUE)) {
  options(error = rlang::entrace)
}

}
}
\seealso{
\code{\link[=with_abort]{with_abort()}} to promote conditions to rlang errors.
\code{\link[=cnd_entrace]{cnd_entrace()}} to manually add a backtrace to a condition.
}
